#!/bin/bash

# The domain of your ID Cloud instance.
# Do not include protocol, or trailing slash.
# Example: "myTenant.forgeblocks.com"
TENANT_DOMAIN=""

# An API key ID and secret, required to access your monitoring endpoints.
# See: https://backstage.forgerock.com/docs/idcloud/latest/paas/tenant/audit-logs.html#api-key
API_KEY_ID=""
API_KEY_SECRET=""

if [[ -z "${API_KEY_ID}" ]]; then
	read -p "Prometheus username (api_key_id): " API_KEY_ID
fi

if [[ -z "${API_KEY_SECRET}" ]]; then
	read -p "Prometheus password (api_key_secret): " API_KEY_SECRET
fi

if [[ -z "${TENANT_DOMAIN}" ]]; then
	 read -p "Tenant domain: " TENANT_DOMAIN
fi

DIR=`pwd`
WORKING_DIR=$(echo "$DIR" | sed 's/\//\\\//g')

cat prometheus/prometheus.tmpl.yml | sed "s/##API_KEY_ID##/${API_KEY_ID}/g" | sed "s/##API_KEY_SECRET##/${API_KEY_SECRET}/g" | sed "s/##TENANT_DOMAIN##/${TENANT_DOMAIN}/g" > prometheus/prometheus.yml

cat docker/docker-compose.tmpl.yml | sed "s/##WORKING_DIR##/${WORKING_DIR}/g" > docker/docker-compose.yml

# Start Prometheus & Grafana in Docker
# docker-compose -f docker/docker-compose.yml down
# docker-compose -f docker/docker-compose.yml up
# --detach

# After first `docker-compose up`, containers can be restarted by stopping and starting:
# docker-compose stop
# docker-compose start

# NB. use `docker-compose rm` to remove the container(s) created by `docker-compose up`
# NB. named volume location on Mac OS: https://stackoverflow.com/questions/39763115/docker-named-volume-location-mac

# NB. The first time Grafana is brought up, its Prometheus data source will need
# to be defined:
#
#     Name:         prometheus
#     Type:         Prometheus
#     URL:          http://prometheus:9090/
#     Access:       Server (Default)
#
# Login to Grafana using admin:admin

# TODO:
# pause script execution and run cleanup after user presses enter
# (in the meantime, run `ps -ef | grep kubectl` and kill all PIDs manually)
# capture PID for each port-forward process so they can be killed
# run docker-compose down / rm

# Access Prometheus from localhost:9090
# Access Grafana from localhost:3000
